
IF EXISTS(
	SELECT 
		ID 
	FROM 
		SYSOBJECTS 
	WHERE 
		NAME = 'V_TELE_AGUARDSEPARACAO' AND XTYPE = 'V')
BEGIN
	DROP VIEW [dbo].[V_TELE_AGUARDSEPARACAO]  
END

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [dbo].[V_TELE_AGUARDSEPARACAO]  
			AS  
			SELECT A.CD_FILIAL
				 , A.CD_ORC
				 , CLI.RZ_CLI
				 , A.DTHR_PEDIDO
				 , A.ENT_DTHR
				 , DATEDIFF(MINUTE, GETDATE(), A.ENT_DTHR) - C.SEPARACAO AS 'Prazo'
				 , 'PD' AS TIPO
				 , PROD_CONTROLADO
				 , ENT_CEP AS CEP
				 , A.CD_CID_LOGRA 
			FROM dbo.TELE_ORC AS A INNER JOIN  
				 dbo.V_TELE_TEMPO_ETAPA AS C ON A.CD_TIPO_ENTREGA = C.CD_TIPO_ENTREGA AND C.CD_FILIAL = A.CD_FILIAL INNER JOIN  
				 dbo.GLB_CID_LOGRA AS L ON L.CD_CID_LOGRA = A.CD_CID_LOGRA  
				 
				 INNER JOIN RC_CLI CLI ON A.CD_CLI = CLI.CD_CLI
				 
			WHERE (A.CD_ETAPAS = 2) AND (A.CD_TIPO = 0) AND 
				   A.DTHR_PEDIDO > DATEADD(MONTH, -3, GETDATE())
				  
			 
			UNION ALL  
			SELECT A.CD_FILIAL
				 , A.CD_OS
				 , CLI.RZ_CLI
				 , A.DTHR
				 , A.DTHR_OS
				 , DATEDIFF(minute, GETDATE(), A.DTHR_OS) AS 'Prazo'
				 , 'OS' AS TIPO
				 , 0 -- CONTROLADO NAO-- E ORDEM DE SERVICO
				 , A.CEP 
				 , A.CD_CID_LOGRA  
			FROM dbo.TELE_OS AS A INNER JOIN  
				 dbo.TELE_OS_ETAPA AS B ON A.CD_OS = B.CD_OS AND A.CD_OS_ETAPA = B.CD_OS_ETAPA INNER JOIN  
				 dbo.GLB_CID_LOGRA AS L ON L.CD_CID_LOGRA = A.CD_CID_LOGRA INNER JOIN 
				 dbo.TELE_ORC ORC ON ORC.CD_ORC = A.CD_ORC INNER JOIN
				 dbo.RC_CLI CLI ON ORC.CD_CLI = CLI.CD_CLI
				 
			WHERE (B.CD_OS_TIPO_STATUS = 1) AND 
				   A.DTHR > DATEADD(MONTH, -3, GETDATE())

GO


